-- Weather Underground to Apple //
-- 2011 Kevin Dady
--  
-- Web Processing:
-- get text data
-- get radar image
-- phrase text for apple //	

web = {}

web.data = {}
web.keywords =
{
	"National Weather Service:",
	"Updated","Windchill","Temperature","Humidity",
	"Conditions","Dew Point"}

web.get = function()
	-- download html from website 
	cmd.wget(cmd.webURL, "text.html")
	-- look for the radar image url
	local file = io.open("temp/text.html")
	local image = ""
	for line in file:lines() do
		if string.find(line, "jpg") then 
			image = line
			break
		end
	end
	file:close()
	-- remove the html tags from image url
	local firstQuote = string.find(image, "\"") + 1
	local secondQuote = string.find(image, "\"", firstQuote) - 1
	image = string.sub(image, firstQuote, secondQuote)
	-- download image
	cmd.wget(image, "radar.jpg")
end

web.sortTXT = function()
	local fileLines = {}
	-- use lynx to strip html tags
	cmd.lynx("temp/text.html")
	-- dump the lynx output file into a table
	local file = io.open("temp/text.txt")
	for line in file:lines() do
		table.insert(fileLines, line)
	end
	-- look for keywords and scrape data
	for y = 1, #fileLines do
		local sub = ""
		-- storm advisory
		if string.find(fileLines[y], web.keywords[1]) ~= nil and web.data[1] == nil then
			sub = string.gsub(fileLines[y + 1], "%d", "!")
			sub = string.gsub(sub, " , ", " ")
			table.insert(web.data, 1, sub)
		-- last updated date and time
		elseif string.find(fileLines[y], web.keywords[2]) ~= nil then
			table.insert(web.data, 2, fileLines[y])
		-- windchill
		elseif string.find(fileLines[y], web.keywords[3]) ~= nil then
			sub = string.gsub(fileLines[y], web.keywords[3], "")
			table.insert(web.data, 3, sub)
    -- everything else
		else		
			for keyWord = 4, (#web.keywords) do
				if string.find(fileLines[y], web.keywords[keyWord]) ~= nil and web.data[keyWord] == nil then
					sub = string.gsub(fileLines[y], web.keywords[keyWord], "")
					table.insert(web.data, keyWord, sub)
				end 
			end
		end
  end
end

web.cleanTXT = function()	
	for y = 1, #web.data do 
		if web.data[y] ~= nil then
			-- remove extra spaces from start of each string
			while (string.sub(web.data[y], 1, 1) == " ") do
				web.data[y] = string.sub(web.data[y], 2, -1)
			end	
			-- remove degrees character
			web.data[y] = string.gsub(web.data[y], "°", "")
		end
	end
	-- Add keywords back in (skipping nill values, and tempature)
	for keyWord = 3, (#web.keywords) do		
		if web.data[keyWord] ~= nil then
			if keyWord ~= 4 then
				web.data[keyWord] = web.keywords[keyWord] .. ": " ..web.data[keyWord]
			end
		end
	end
	-- remove / from Temperature
 	web.data[4] = string.gsub(web.data[4], " / ", " ")
end





